/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTask;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class StartupApp
extends PanelTask
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMLCTT";
    private static final String TRACE_MASKF = "XFRMLCTF";
    private static final String TRACE_MASKD = "XFRMLCTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "StartupApp");
    private static final String STARTUP_TASKLET = "com.ibm.hwmca.fw.system.StartupTasklet";
    private static String autoLogonUserid = null;
    private static byte[] autoLogonPassword = null;

    static void setAutoLogonData(String userid, byte[] password) {
        Trace.trace(TRACE_MASKF, "<> StartupApp.setAutoLogonData()");
        autoLogonUserid = userid;
        autoLogonPassword = password;
    }

    public static Object[] getAutoLogonData() {
        Object[] data = new Object[]{autoLogonUserid, autoLogonPassword};
        autoLogonUserid = null;
        autoLogonPassword = null;
        return data;
    }

    public StartupApp() throws TaskletException {
        super(new PresentationTaskParms(null), STARTUP_TASKLET);
    }

    public StartupApp(PresentationTaskParms parms) throws TaskletException {
        super(parms, STARTUP_TASKLET);
    }

    public Object runTask() throws Exception {
        PanelModelTaskPortal portal = this.getPanelModelTaskPortal();
        if (portal != null) {
            Trace.trace(TRACE_MASKD, "StartupApp: running in html mode.. setting needed parameters");
            portal.setWindowName("hmcPreLogonPage");
            portal.setWindowOpen(true);
            portal.setRefreshEnabled(false);
            portal.setEmbedded(true);
            String redirectURL = (String)this.getParms().getData("redirectURL");
            if (redirectURL != null) {
                portal.setRedirectURL(redirectURL);
            }
        }
        super.runTask();
        if (portal != null) {
            try {
                PanelModel pmod = portal.getCurrentPanelModel();
                if (pmod != null) {
                    Trace.trace(TRACE_MASKD, "StartupApp: waiting for panel to be rendered");
                    pmod.getImplAccess().waitForSerializationStart();
                    Trace.trace(TRACE_MASKD, "StartupApp: panel has been rendered");
                } else {
                    Trace.trace(TRACE_MASKF, "StartupApp: PanelModel was null");
                }
            }
            catch (TaskEndedException e) {
                Trace.trace(TRACE_MASKF, e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- StartupApp.runTask()");
        return null;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> StartupApp.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(classLogInfo, 63, throwable).log();
        Trace.trace(TRACE_MASKT, "<- StartupApp.logException()");
    }
}

